#load data file
data<-read.table("Exp4 data.txt",header=T)
str(data)

data$cb<-as.factor(data$cb)
data$subject<-as.factor(data$subject)
data$code<-as.factor(data$code)
data$item<-as.factor(data$item)
data$trial<-as.factor(data$trial)
data$enh_pos<-as.factor(data$enh_pos)
str(data)


ifelse(grepl('b',data$cb),"b","a")->data$key

with(data, aggregate(acc=="cor",by=list(subject=subject),mean))->subacc
names(subacc)[2]<-"accuracy"

subacc$subject[subacc$accuracy<0.56]->under56

#high subject accuracy

subset(data,!subject%in%under56)->dh #data of high accuracy subjects only



#creating simulation file with aggregated data

#different trials

subset(dh, trial=="different"&diff_alt=="unique")->diffsubstitute
with(diffsubstitute,aggregate(acc=="cor",by=list(item=item,target=target_type),mean))->diffsubmeans

subset(dh, trial=="different"&diff_alt=="repeated")->diffwrongrepeat
with(diffwrongrepeat,aggregate(acc=="cor",by=list(item=item,target=target_type),mean))->diffwrongrepeatmeans

#same trials; keeping diff_alt to produce the same number of observations as the different trials

subset(dh, trial=="same"&diff_alt=="unique")->samesubstitute
with(samesubstitute,aggregate(acc=="cor",by=list(item=item,target=target_type),mean))->samesubmeans

subset(dh, trial=="same"&diff_alt=="repeated")->samewrongrepeat
with(samewrongrepeat,aggregate(acc=="cor",by=list(item=item,target=target_type),mean))->samewrongrepeatmeans


#different trials

read.table("desexp4replace.txt")->exp4dessub.txt #load stimuli with substition ("unique") foils
read.table("desExp4repeat.txt")->exp4deswrongrep.txt #load stimuli with wrong repetition ("repeat") foils

data.frame(cbind(diffsubmeans[,1],diffsubmeans[,3],as.character(diffsubmeans[,2]),rep("substitute",dim(diffsubmeans)[1]),tolower(as.character(exp4dessub.txt[,1])),
tolower(as.character(exp4dessub.txt[,2]))))->exp4sub

data.frame(cbind(diffwrongrepeatmeans[,1],diffwrongrepeatmeans[,3],as.character(diffwrongrepeatmeans[,2]),rep("wrongrep",dim(diffwrongrepeatmeans)[1]),tolower(as.character(exp4deswrongrep.txt[,1])),
tolower(as.character(exp4deswrongrep.txt[,2]))))->exp4wrongrep

#write.table(rbind(exp4sub,exp4wrongrep),"exp4parfit.txt",row.names=F,col.names=F,quote=F)

rbind(exp4sub,exp4wrongrep)->alldata 

rep(c(1,2),512)->alldata$critpos #adding critpos factor (1 or 2)
c(rep(2,64),rep(3,64),rep(4,64),rep(5,64))->alldata$rep1 #adding first position of repetition factor
c(rep(1,2),rep(0,62))->alldata$examples #creating exemplar stimuli from each group
alldata[alldata$examples==1,5:6] #selecting stimuli


with(alldata,aggregate(as.numeric(as.character(alldata$X2)),by=list(critpos=critpos,rep1=rep1,target=X3,foil=X4),mean))->aggdata

dataf<-cbind(aggdata[,c(2,5,3,4)],alldata[alldata$examples==1,5:6])


#repeat with same trials

data.frame(cbind(samesubmeans[,1],samesubmeans[,3],as.character(samesubmeans[,2]),rep("substitute",dim(samesubmeans)[1]),tolower(as.character(exp4dessub.txt[,1])),
tolower(as.character(exp4dessub.txt[,2]))))->exp4Ssub


data.frame(cbind(samewrongrepeatmeans[,1],samewrongrepeatmeans[,3],as.character(samewrongrepeatmeans[,2]),rep("wrongrep",dim(samewrongrepeatmeans)[1]),tolower(as.character(exp4deswrongrep.txt[,1])),
tolower(as.character(exp4deswrongrep.txt[,2]))))->exp4Swrongrep

rbind(exp4Ssub,exp4Swrongrep)->alldataS

rep(c(1,2),512)->alldataS$critpos
c(rep(2,64),rep(3,64),rep(4,64),rep(5,64))->alldataS$rep1
c(rep(1,2),rep(0,62))->alldataS$examples
alldataS[alldataS$examples==1,5:6]

with(alldataS,aggregate(as.numeric(as.character(alldataS$X2)),by=list(critpos=critpos,rep1=rep1,target=X3,foil=X4),mean))->aggdataS

datafS<-cbind(aggdataS[,c(2,5,3,4)],alldataS[alldataS$examples==1,5],alldataS[alldataS$examples==1,5])


datafS$V7<-rep(c(1,2),16)
dataf$V7<-rep(c(1,2),16)
datafS$V8<-"same"
dataf$V8<-"different"
names(datafS)[5:6]<-names(dataf)[5:6]


rbind(dataf,datafS)->datashortSD
write.table(datashortSD,"datashortExp4SD.txt",row.names=F,col.names=F,quote=F) #export simulation file with aggregated data 
